
PiTap
=====

Raspberry Pi Datasette and Tapecart emulator.

PiTap allows you to interface a Raspberry Pi to the cassette port of the Commodore 64.  It consists of a bare metal Pi kernel and a simple interface circuit between the Pi's GPIO pins and the Commodore.  Tap files may be loaded from and saved to the Pi's SD card.  PRG, D64 and T64 files are also supported through automatic conversion to turbo tap images.  SID files are supported with an included SID player.  PiTap also acts as a Tapecart device.

It should run on any Pi3, Pi4 or the Zero 2w.  Control of PiTap for file selection, play, record, etc. is via the Pi's monitor and keyboard, via web interface or using a mini OLED display and buttons on the PCB.

The interface circuit is shown at https://gp2x.org/pitap/pitap.png.  It uses a Sparkfun BOB-12009 level shifter and a 4N35 transistor.  It optionally may use a SSD1306 OLED display and 5 push-buttons.

This is a continuation of my old uno2tap Arduino/tap project, ported to the Pi.

PiTap is built on the Circle RPi bare metal programming environment.  It was inspired by Pottendo's Circle port of Pi1541 and uses some web server code from that.  The level shifter is the same as used in Pi1541 and the motor reading circuit is from the Tapuino.  The PRG to tap conversion uses code from Thorsten Kattanek's command line converter and the turbo tape support uses Enthusi's loader.  Tapecart support is adapted from Ingo Korb's Tapecart project and Kim Jorgensen's Tapecart SD.  Thanks to all behind these great projects.

The binary distribution includes Tapecart SD Browser by Kim Jorgensen and Draco, available from https://github.com/KimJorgensen/tapecart, Tapecart Browser by ALeX Kazik, available from https://github.com/alexkazik/tapecart-browser and Sidplay64 Tapecart-SD edition from https://csdb.dk/release/?id=215008 by G.R. Gallefoss.

The software is GPL.  If anyone wants to build and sell the hardware interface please do so.

To install copy the contents of the zip file to the root of a normal vfat-formatted SD card, then use this to boot the Pi.  Tap files should be copied to the same card.  Amend wpa_supplicant.conf for your network.

Use the Pi keyboard, web interface or PCB buttons to select and mount a tap image, press shift and run-stop, then press play on the PiTap.


Home page: https://gp2x.org/pitap/

Contact: mike@gp2x.org

