//
// tap.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _tap_h
#define _tap_h

#include <circle/actled.h>
#include <circle/gpiopin.h>
#include <circle/spinlock.h>
#include <circle/timer.h>
#include <circle/types.h>

#define TAP_HDR 0x00
#define TAP_VER 0x0c
#define TAP_PLT 0x0d
#define TAP_VID 0x0e
#define TAP_RES 0x0f
#define TAP_SIZ 0x10
#define TAP_DAT 0x14

#define TAP_PIN_LED_MOTOR   0
#define TAP_PIN_LED_RECORD  1
#define TAP_PIN_LED_PLAY   12

#define TAP_PIN_MOTOR  7
#define TAP_PIN_READ   8
#define TAP_PIN_WRITE  9
#define TAP_PIN_SENSE 11

class Tap
{
public:
	Tap (CTimer *pTimer);
	~Tap (void);

	boolean Initialize (void);

	void hwInterface (void);

	unsigned getCounterSeconds (void);
	u64 getLastPulseLength (void);
	unsigned getMissedPulses (void);
	boolean getMotor (void);
	unsigned getPos (void);
	unsigned getTapLength (void);
	unsigned getTapSize (void);
	boolean isBusy(void);
	boolean isPlaying(void);
	boolean isRecording(void);
	int mountTap (char *tap, const unsigned length);
	int playTap (void);
	int recordTap (char *buffer, const unsigned length);
	int seekBytes (const unsigned pos);
	int seekSeconds (const unsigned time_s);
	void stopTap (void);
	u64 pos2time (unsigned pos);

	CGPIOPin GPIOMotor;
	CGPIOPin GPIORead;
	CGPIOPin GPIOWrite;
	CGPIOPin GPIOSense;

	CGPIOPin GPIOLEDMotor;
	CGPIOPin GPIOLEDRecord;
	CGPIOPin GPIOLEDPlay;

	boolean sense_on=FALSE;

	boolean optionAutoRewind=TRUE;
	boolean optionAutoStop=TRUE;

private:
	unsigned time2pos (u64 time_us);
	void setSizeHeader (void);

	CSpinLock tapControlLock;

	CTimer	*m_pTimer;
};

#endif

