//
// status.cpp
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <string.h>

#include "status.h"

Status::Status (void)
{
}

Status::~Status (void)
{
}

boolean Status::Initialize(void)
{
	options[CONVERSION_TYPE].name="conversionType";
	options[CONVERSION_TYPE].option_type=OPTION_CHOICE;
	options[CONVERSION_TYPE].label="Conversion type";
	options[CONVERSION_TYPE].description="Convert PRG, T64, D64, P00 files to tapecart or tape format.";

	options[TAP_CONVERSION_FORMAT].name="tapConversionFormat";
	options[TAP_CONVERSION_FORMAT].option_type=OPTION_CHOICE;
	options[TAP_CONVERSION_FORMAT].label="Tape conversion format";
	options[TAP_CONVERSION_FORMAT].description="For tape conversions, use kernal or Turbo Tape 64 format.";

	options[TCRT_SENSEMODE].name="tcrtSensemode";
	options[TCRT_SENSEMODE].option_type=OPTION_BOOLEAN;
	options[TCRT_SENSEMODE].label="Enable tapecart sense mode";
	options[TCRT_SENSEMODE].description="Required for tapecart mode to work properly, but makes it look to the C64 like a tape is always playing.";

	return TRUE;
}

CString Status::getOptionsJson()
{
	CString json="{\n";
	CString tmp;
	const char *type="";
	const char *choices;
	const char *value;

	for(int i=0; i<NUM_OPTIONS; i++)
	{
		if(options[i].option_type==OPTION_BOOLEAN) type="boolean";
		else if(options[i].option_type==OPTION_STRING) type="string";
		else if(options[i].option_type==OPTION_CHOICE) type="choice";

		value="";
		choices="";

		switch(i)
		{
			case CONVERSION_TYPE:
				choices="\"choices\": [ \"Tape\", \"Tapecart\" ], ";
				if(optionConvertToTapecart) value="\"Tapecart\"";
				else value="\"Tape\"";
				break;
			case TAP_CONVERSION_FORMAT:
				choices="\"choices\": [ \"Kernal\", \"TurboTape64_with_loader\", \"TurboTape64\" ], ";
				if(optionTapConversionFormat==KERNAL) value="\"Kernal\"";
				else if(optionTapConversionFormat==TURBOTAPE64) value="\"TurboTape64\"";
				else value="\"TurboTape64_with_loader\"";
				break;
			case TCRT_SENSEMODE:
				if(optionShiftregEnableSense) value="true";
				else value="false";
				break;
			default:
				break;
		}

		tmp.Format("\"%s\": { "
				"\"label\": \"%s\", "
				"\"description\": \"%s\", "
				"\"type\": \"%s\", "
				"%s"
				"\"value\": %s "
				" }",
				options[i].name,
				options[i].label,
				options[i].description,
				type,
				choices,
				value
				);

		if(i<(NUM_OPTIONS-1)) tmp+=",\n";
		else tmp+="\n";
		json+=tmp;
	}

	json+="}\n";
	return json;
}

void Status::setOptions(const char *opts)
{
	char *option;

	option=strstr(opts, "conversionType=");
	if(option)
	{
		if(!strncmp(option+strlen("conversionType="), "Tapecart", 8)) optionConvertToTapecart=TRUE;
		else optionConvertToTapecart=FALSE;
	}

	option=strstr(opts, "tapConversionFormat=");
	if(option)
	{
		if(!strncmp(option+strlen("tapConversionFormat="), "Kernal", 6))
			optionTapConversionFormat=KERNAL;
		else if(!strncmp(option+strlen("tapConversionFormat="), "TurboTape64_with_loader", 23))
			optionTapConversionFormat=TURBOTAPE64_WITH_LOADER;
		else if(!strncmp(option+strlen("tapConversionFormat="), "TurboTape64", 11))
			optionTapConversionFormat=TURBOTAPE64;
		else
			optionTapConversionFormat=TURBOTAPE64_WITH_LOADER;
	}

	option=strstr(opts, "tcrtSensemode=");
	if(option)
	{
		if(!strncmp(option+strlen("tcrtSensemode="), "true", 4)) optionShiftregEnableSense=TRUE;
		else optionShiftregEnableSense=FALSE;
	}
}

