//
// lcd.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef _lcd_h
#define _lcd_h

#include <display/ssd1306display.h>
#include <circle/terminal.h>
#include <circle/timer.h>

#define PIN_BUTTON1 27
#define PIN_BUTTON2 22
#define PIN_BUTTON3 23
#define PIN_BUTTON4  4
#define PIN_BUTTON5  5

class LCD 
{
public:
	LCD (CTimer *pTimer);
	~LCD (void);

	boolean Initialize (void);
	void setContent (unsigned line, const char *buf, boolean reverse=FALSE);
	void updateButtons (void);

	boolean buttonOn[5];
	boolean buttonDepress[5];
	u64 buttonPressTime[5];

private:
	boolean		lcdConnected;

	unsigned	fontWidth=8;
	unsigned	fontHeight=8;
	unsigned	lcdWidth=128;
	unsigned	lcdHeight=64;

	CTimer		*m_pTimer;
	CI2CMaster	m_i2c;
	CSSD1306Display	m_lcd;
};

#endif

