//
// kernel.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _kernel_h
#define _kernel_h

#include <circle/actled.h>
#include <circle/cputhrottle.h>
#include <circle/koptions.h>
#include <circle/memory.h>
#include <circle/multicore.h>
#include <circle/devicenameservice.h>
#include <circle/screen.h>
#include <circle/serial.h>
#include <circle/exceptionhandler.h>
#include <circle/interrupt.h>
#include <circle/timer.h>
#include <circle/logger.h>
#include <circle/usb/usbhcidevice.h>
#include <circle/sched/scheduler.h>
#include <wlan/bcm4343.h>
#include <wlan/hostap/wpa_supplicant/wpasupplicant.h>
#include <circle/net/netsubsystem.h>
#include <circle/machineinfo.h>
#include <circle/types.h>
#include <SDCard/emmc.h>

#include "cores.h"
#include "display.h"
#include "file.h"
#include "fs.h"
#include "lcd.h"
#include "status.h"
#include "tap.h"
#include "tapecart.h"
#include "taputils.h"

enum TShutdownMode
{
        ShutdownNone,
        ShutdownHalt,
        ShutdownReboot
};


class CKernel
{
public:
        CKernel (void);
        ~CKernel (void);

        boolean Initialize (void);

        TShutdownMode Run (void);

private:
        CActLED                 m_ActLED;
        CKernelOptions          m_Options;
        CDeviceNameService      m_DeviceNameService;
        CSerialDevice           m_Serial;
        CExceptionHandler       m_ExceptionHandler;
        CInterruptSystem        m_Interrupt;
        CTimer                  m_Timer;
        CLogger                 m_Logger;

	CMachineInfo		m_MachineInfo;
	CUSBHCIDevice		m_USBHCI;
	CScheduler		m_Scheduler;

	CEMMCDevice		m_EMMC;
	FATFS			m_FileSystem;

	CBcm4343Device		m_WLAN;
	CNetSubSystem		m_Net;
	CWPASupplicant		m_WPASupplicant;

	CCPUThrottle		m_CPUThrottle;

	Status			m_Status;
	Tap			m_Tap;
	TapeCart		m_TapeCart;
	TapCores		m_TapCores;
	FS			m_FS;
	LCD			m_LCD;
	Display			m_Display;
	TapUtils		m_TapUtils;
	File			m_File;
};

#endif

