//
// file.h
//
// Circle - A C++ bare metal environment for Raspberry Pi
// Copyright (C) 2015  R. Stange <rsta2@o2online.de>
// 
// PiTap (C) 2025 Mike Dawson https://gp2x.org/pitap
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//


#ifndef _file_h
#define _file_h

#include <circle/types.h>
#include <fatfs/ff.h>

class File
{
public:
	File (void);
	~File (void);

	boolean Initialize (void);

	boolean fileStat (const char *f);
	int readDir (FILINFO *dirlist, unsigned max, const char *dir);
	int writeFile (const u8 *data, unsigned size, const char *filename);
	int mkDir (const char *dir);
	int rm (const char *path);

private:
	void bsort(FILINFO *, int);

};

#endif

